IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES
			 WHERE TABLE_NAME='CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS')
begin
CREATE TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS](
	[CD_CTR_GRUPO] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_VD] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
 CONSTRAINT [PK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS] PRIMARY KEY CLUSTERED 
(
	[CD_CTR_GRUPO] ASC,
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_VD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS_CD_CTR_GRUPO]  DEFAULT ((0)) FOR [CD_CTR_GRUPO]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS_CD_VD]  DEFAULT ((0)) FOR [CD_VD]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS] ADD  CONSTRAINT [DF_CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS_CG_FND_VERBA_NOTA_CREDITO_GRUPO] FOREIGN KEY([CD_CTR_GRUPO])
REFERENCES [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO] ([CD_CTR_GRUPO])

ALTER TABLE [dbo].[CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS] CHECK CONSTRAINT [FK_CG_FND_VERBA_NOTA_CREDITO_GRUPO_VENDAS_CG_FND_VERBA_NOTA_CREDITO_GRUPO]
end

